#ifndef DTACHYONSETTINGS_H
#define DTACHYONSETTINGS_H

enum
{
    TACHYON_SETTINGSGROUP_BASIC = 3000,
    TACHYON_SETTINGSGROUP_BASIC_AA = 3001,
    TACHYON_SETTINGSGROUP_BASIC_GENERAL = 3002,
    TACHYON_SETTINGSGROUP_BASIC_SHADERS = 3003,
    TACHYON_SETTINGSGROUP_ENVIRONMENT = 3100,
    TACHYON_SETTINGSGROUP_ENVIRONMENT_BG = 3101,
    TACHYON_SETTINGSGROUP_ENVIRONMENT_MAP = 3102,
    TACHYON_SETTINGSGROUP_REFLECTANCE = 3200,
    TACHYON_SETTINGSGROUP_SHADOWS = 3300,
    TACHYON_SETTINGSGROUP_EFFECTS = 3400,
    TACHYON_SETTINGSGROUP_EFFECTS_MB = 3401,
    TACHYON_SETTINGSGROUP_EFFECTS_DOF = 3402,
    TACHYON_SETTINGSGROUP_EFFECTS_AO = 3403,
    TACHYON_SETTINGSGROUP_EFFECTS_BLOOM = 3405,
    TACHYON_SETTINGSGROUP_TONEMAPPING = 3500,
    TACHYON_SETTINGSGROUP_TONEMAPPING_TONE = 3501,
    TACHYON_SETTINGSGROUP_GAMMA = 3502,
    TACHYON_SETTINGSGROUP_MULTI_PASS_SETTINGS = 3600,
    TACHYON_SETTINGSGROUP_POSTPROCESS = 3700,
    TACHYON_SETTINGSGROUP_CHROMATIC_ABERRATION = 3800,
    TACHYON_SETTINGSGROUP_VIGNETTE = 3900,
    TACHYON_SETTINGSGROUP_FOG = 4000,
    TACHYON_SETTINGSGROUP_VOLUMETRICS = 4100,

    TACHYON_SETTINGSGROUP_INFINITE_LIGHT_SHADOWS = 1000,

    //TACHYON_SETTINGS_CASCADE_COUNT = 1001,
    //TACHYON_SETTINGS_SPLIT_WEIGHT = 1002,

    TACHYON_SETTINGS_DEFAULT_SHADOW_MAP_SIZE = 1003,
    TACHYON_SETTINGS_SHADOW_MAP_SIZE_256 = 1,
    TACHYON_SETTINGS_SHADOW_MAP_SIZE_512 = 2,
    TACHYON_SETTINGS_SHADOW_MAP_SIZE_1024 = 3,
    TACHYON_SETTINGS_SHADOW_MAP_SIZE_2048 = 4,
    TACHYON_SETTINGS_SHADOW_MAP_SIZE_4096 = 5,
    TACHYON_SETTINGS_SHADOW_MAP_SIZE_8192 = 6,
    TACHYON_SETTINGS_SHADOW_MAP_SIZE_16384 = 7,

    TACHYON_SETTINGS_MAX_SHADOW_MAP_SIZE = 1004,
    TACHYON_SETTINGS_USE_MAX_SHADOW_MAP_SIZE = 5001,

    TACHYON_SETTINGS_AMBIENT_LIGHT_COLOR = 1005,
    TACHYON_SETTINGS_BACKGROUND_COLOR = 1006,

    TACHYON_SETTINGS_RENDERING_NAME = 1010,
    TACHYON_SETTINGS_EXPORT_ANIMATIONS = 1011,
    TACHYON_SETTINGS_BUTTON_RENDER = 1012,

    TACHYON_SETTINGS_OUTPUT_PATH = 1013,

    TACHYON_SETTINGS_SSAO_ALGORITHM = 11000,
        TACHYON_SETTINGS_SSAO_ALGORITHM_HEMISPHERE_SSAO = 1,
        TACHYON_SETTINGS_SSAO_ALGORITHM_GTAO = 3,

    // Common parameters
    TACHYON_SETTINGS_SSAO_ENABLE = 1020,
    TACHYON_SETTINGS_SSAO_RADIUS = 1021,
    TACHYON_SETTINGS_SSAO_POWER = 1022,
    // Hemisphere SSAO
    TACHYON_SETTINGS_SSAO_SAMPLES = 1023,
    TACHYON_SETTINGS_SSAO_HEMISPHERE_OFFSET = 1024,
    // GTAO
    TACHYON_SETTINGS_GTAO_RADIUS_LIMIT = 11006,
    TACHYON_SETTINGS_GTAO_FALLOFF_START = 11004,
    TACHYON_SETTINGS_GTAO_FALLOFF_END = 11005,
    TACHYON_SETTINGS_GTAO_FILTER_PASSES = 11001,
    TACHYON_SETTINGS_GTAO_HORIZON_SEARCH_STEPS = 11002,
    TACHYON_SETTINGS_GTAO_TEMPORAL_FILTER_FOR_LIVE = 11003,
    TACHYON_SETTINGS_GTAO_ENABLE_DEPTH_PEELS = 11010,
    TACHYON_SETTINGS_GTAO_ENABLE_BACKFACE_PEELS = 11011,
    TACHYON_SETTINGS_GTAO_NUM_DEPTH_LAYERS = 11012,

    TACHYON_SETTINGS_AA_MODE = 1025,
    TACHYON_SETTINGS_AA_MODE_NONE = 0,
    TACHYON_SETTINGS_AA_MODE_FXAA = 1,
    TACHYON_SETTINGS_AA_MODE_FXAA3 = 2,

    TACHYON_SETTINGS_SUPER_SAMPLING_ENABLE = 1026,

    TACHYON_SETTINGS_SUPER_SAMPLING_COUNT = 1027,

    TACHYON_SETTINGS_SUPER_SAMPLING_FILTER_SIZE = 1028,

    TACHYON_SETTINGS_SHADOW_DUAL_MAX_DEPTH_OFFSET = 1030,

    TACHYON_SETTINGS_BACKGROUND_OPACITY = 1040,

    TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE = 1041,
        TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE_DEFAULT = 0,
        TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE_SRGB = 1,
        TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE_LINEAR = 2,
        TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE_CUSTOM = 3,
    TACHYON_SETTINGS_OUTPUT_COLOR_GAMMA = 1042,

    TACHYON_SETTINGS_ENVIRONMENT_TEXTURE = 2050,
    TACHYON_SETTINGS_ENVIRONMENT_GAMMA_ENABLE = 2051,
    TACHYON_SETTINGS_ENVIRONMENT_GAMMA = 2052,
    TACHYON_SETTINGS_ENVIRONMENT_AZIMUTHAL_ROTATION = 2053,
    TACHYON_SETTINGS_ENVIRONMENT_REPLACE_BACKGROUND = 2054,
    TACHYON_SETTINGS_ENVIRONMENT_BLUR_FACTOR = 2055,

	// ssrr [2060 - 2069]
    TACHYON_SETTINGS_SSRR_MODE = 2060,
    TACHYON_SETTINGS_SSRR_MODE_PERFORMANCE = 0,
    TACHYON_SETTINGS_SSRR_MODE_DEFAULT = 1,
    TACHYON_SETTINGS_SSRR_MODE_QUALITY = 2,

	TACHYON_SETTINGS_SSRR_ENABLED = 2069,

    TACHYON_SETTINGS_SSRR_ITERATIONS = 2064,
	TACHYON_SETTINGS_SSRR_PIXEL_STRIDE = 2068,
	TACHYON_SETTINGS_SSRR_BINARY_SEARCH_STEPS = 2065,
    TACHYON_SETTINGS_SSRR_JITTER_FACTOR = 2066,

	TACHYON_SETTINGS_SSRR_FADE_SCREEN_EDGE_START = 2061,
	TACHYON_SETTINGS_SSRR_FADE_SCREEN_EDGE_END = 2062,
	
	TACHYON_SETTINGS_SSRR_FADE_DISTANCE_START = 2063,
	TACHYON_SETTINGS_SSRR_FADE_DISTANCE_END = 2067,

	// motion blur
    TACHYON_SETTINGS_MOTION_BLUR_ENABLE = 2070,
    TACHYON_SETTINGS_MOTION_BLUR_LOOPCOUNT = 2071,

	// dof
    TACHYON_SETTINGS_DOF_ENABLE = 2072,
    TACHYON_SETTINGS_DOF_SAMPLE_COUNT = 2073,

    TACHYON_SETTINGS_IBL_ENABLE = 2500,
    TACHYON_SETTINGS_IBL_EXPOSURE = 2501,
    TACHYON_SETTINGS_IBL_SAMPLES = 2502,
    TACHYON_SETTINGS_IBL_OCCLUSION = 2503,
    TACHYON_SETTINGS_IBL_SPECULAR_EXPOSURE = 2504,


    TACHYON_SETTINGS_TONE_MAPPING_ENABLE = 2601,
    TACHYON_SETTINGS_TONE_MAPPING_EXPOSURE = 2602,
    TACHYON_SETTINGS_TONE_MAPPING_WHITE_POINT = 2603,
    TACHYON_SETTINGS_TONE_MAPPING_BLACK_POINT = 2604,
    TACHYON_SETTINGS_TONE_MAPPING_COLORSPACE_HSV = 2605,
    TACHYON_SETTINGS_TONE_MAPPING_MODE = 2606,
    TACHYON_SETTINGS_TONE_MAPPING_MODE_LINEAR = 0,
    TACHYON_SETTINGS_TONE_MAPPING_MODE_EXPONENTIAL = 1,
    TACHYON_SETTINGS_TONE_MAPPING_MODE_REINHARD = 2,
    TACHYON_SETTINGS_TONE_MAPPING_MODE_FILMIC = 3,

	// [DEPRECATED] since background generation is before multi sample loop
    TACHYON_SETTINGS_TONE_MAPPING_APPLY_ON_BACKGROUND = 2607,	

    TACHYON_SETTINGSGROUP_BASIC_DISPLACEMENT = 2700,
    TACHYON_SETTINGS_DISPLACEMENT_ENABLE = 2701,
    TACHYON_SETTINGS_DISPLACEMENT_LIMIT_STEPS = 2702,
    TACHYON_SETTINGS_DISPLACEMENT_MAX_STEPS = 2703,

    TACHYON_SETTINGS_BLOOM_ENABLE = 2800,
    TACHYON_SETTINGS_BLOOM_INTENSITY = 2802,
	TACHYON_SETTINGS_BLOOM_FIREFLY_REDUCTION = 2803,
	TACHYON_SETTINGS_BLOOM_INNER_WEIGHT = 2804,
	TACHYON_SETTINGS_BLOOM_OUTER_WEIGHT = 2805,

    TACHYON_SETTINGS_GENERAL_DEFAULT_LIGHT = 2900,
    TACHYON_SETTINGS_GENERAL_STANDALONE_AUTOSTART_ENABLED = 2901,
    TACHYON_SETTINGS_GENERAL_STANDALONE_AUTOSTART_FOR_MATERIAL_ENABLED = 2902,
    TACHYON_SETTINGS_GENERAL_RENDER_RESOLUTION_OVERSCAN_PERCENT_X = 2903,
    TACHYON_SETTINGS_GENERAL_RENDER_RESOLUTION_OVERSCAN_PERCENT_Y = 2904,

    TACHYON_SETTINGS_SHADER_RENDER_RESOLUTION_LOW = 2930,
    TACHYON_SETTINGS_SHADER_RENDER_RESOLUTION_MEDIUM = 2931,
    TACHYON_SETTINGS_SHADER_RENDER_RESOLUTION_HIGH = 2932,

    TACHYON_SETTINGS_SHADER_MATERIAL_PREVIEW_RESOLUTION = 2950,
    TACHYON_SETTINGS_SHADER_LIVEMODE_RESOLUTION = 2951,

    TACHYON_SETTINGS_SHADER_RESOLUTION_128 = 7,
    TACHYON_SETTINGS_SHADER_RESOLUTION_256 = 8,
    TACHYON_SETTINGS_SHADER_RESOLUTION_512 = 9,
    TACHYON_SETTINGS_SHADER_RESOLUTION_1024 = 10,
    TACHYON_SETTINGS_SHADER_RESOLUTION_2048 = 11,
    TACHYON_SETTINGS_SHADER_RESOLUTION_4096 = 12,

    //TACHYON_SETTINGS_MULTI_PASS_ENABLE = 3601,
	TACHYON_SETTINGS_MULTI_PASS_ANTI_ALIASING = 3603,
    TACHYON_SETTINGS_MULTI_PASS_RGBA = 3610,
    TACHYON_SETTINGS_MULTI_PASS_DIFFUSE = 3611,
    TACHYON_SETTINGS_MULTI_PASS_SPECULAR = 3612,
    TACHYON_SETTINGS_MULTI_PASS_SHADOW = 3613,
    TACHYON_SETTINGS_MULTI_PASS_REFLECTION = 3614,
    TACHYON_SETTINGS_MULTI_PASS_REFRACTION = 3615,
    TACHYON_SETTINGS_MULTI_PASS_AMBIENT_OCCLUSION = 3616,
    TACHYON_SETTINGS_MULTI_PASS_OBJECT_ID = 3617,
    TACHYON_SETTINGS_MULTI_PASS_DEPTH = 3618,
    TACHYON_SETTINGS_MULTI_PASS_MATERIAL_ID = 3619,
    TACHYON_SETTINGS_MULTI_PASS_MATERIAL_DIFFUSE = 3620,
    TACHYON_SETTINGS_MULTI_PASS_MATERIAL_SPECULAR = 3621,
    TACHYON_SETTINGS_MULTI_PASS_MATERIAL_NORMAL = 3622,
    TACHYON_SETTINGS_MULTI_PASS_MATERIAL_UVW = 3623,
    TACHYON_SETTINGS_MULTI_PASS_DIFFUSE_IBL = 3624,
    TACHYON_SETTINGS_MULTI_PASS_MATERIAL_EMISSIVE = 3625,
    TACHYON_SETTINGS_MULTI_PASS_POSTEFFECT_NOTE = 3626,
    TACHYON_SETTINGSGROUP_MULTI_PASS_LIGHTING = 3691,
    TACHYON_SETTINGSGROUP_MULTI_PASS_MATERIAL = 3692,
    TACHYON_SETTINGSGROUP_MULTI_PASS_ADVANCED = 3693,
    TACHYON_SETTINGSGROUP_MULTI_PASS_MATTE = 3694,

    TACHYON_SETTINGS_CHROMATIC_ABERRATION_ENABLE = 3801,
    TACHYON_SETTINGS_CHROMATIC_ABERRATION_STRENGTH = 3802,

    TACHYON_SETTINGS_VIGNETTE_ENABLE = 3901,
    TACHYON_SETTINGS_VIGNETTE_RADIUS = 3902,
    TACHYON_SETTINGS_VIGNETTE_SOFTNESS = 3903,
    TACHYON_SETTINGS_VIGNETTE_STRENGTH = 3904,

	TACHYON_SETTINGS_FOG_ENABLE = 4001,
	TACHYON_SETTINGS_FOG_TYPE = 4002,
		TACHYON_SETTINGS_FOG_TYPE_SIMPLE = 1,
	TACHYON_SETTINGS_FOG_FALLOFF_TYPE = 4003,
		TACHYON_SETTINGS_FOG_FALLOFF_TYPE_NONE =  0,
		TACHYON_SETTINGS_FOG_FALLOFF_TYPE_LINEAR = 1,
		TACHYON_SETTINGS_FOG_FALLOFF_TYPE_EXPONENTIAL = 2,
	TACHYON_SETTINGS_FOG_COLOR = 4005,
	TACHYON_SETTINGS_FOG_DENSITY = 4006,
	TACHYON_SETTINGS_FOG_DISTANCE = 4007,
	TACHYON_SETTINGS_FOG_HEIGHT_FALLOFF = 4008,
	TACHYON_SETTINGS_FOG_HEIGHT = 4009,
    TACHYON_SETTINGS_FOG_BACKGROUND_STRENGTH = 4010,

    TACHYON_SETTINGS_DEBUG_FORCE_USE_RENDER_RESOLUTION = 9001,

    TACHYON_SETTINGS_VOLUMETRICS_ENABLE = 5010,
    TACHYON_SETTINGS_VOLUMETRICS_RESOLUTION_XYZ = 5011,
    // 5012, 5013, 5014 reserved if we decide to make it 3x floats
    TACHYON_SETTINGS_VOLUMETRICS_RESOLUTION_SCALE = 5015,

    TACHYON_SETTINGS_VOLUMETRICS_TEMPORAL_JITTER_RADIUS = 5021,

    TACHYON_SETTINGS_VOLUMETRICS_DENSITY_SCALE = 5016,

    //--------------------------------------------------------------------------------
    // DevTools
    //--------------------------------------------------------------------------------
    TACHYON_SETTINGSGROUP_DEVTOOLS = 99000,
};

#endif
